(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5292,        163]*)
(*NotebookOutlinePosition[      6136,        190]*)
(*  CellTagsIndexPosition[      6092,        186]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ 
      Example\ 3.2 \( \(.3\)\(.\)\)\ *) \[IndentingNewLine]a = \[Lambda]\ \
h*{{2/3, \ 4/3}, {2/3, \ 4/3}}; 
    b = \[Lambda]\ h*{{1/3, \ 0}, \ {5/6, \ 1/2}};\), "\[IndentingNewLine]", 
    \(\(c = IdentityMatrix[2] + b;\)\), "\[IndentingNewLine]", 
    \(d = Inverse[c]\)}], "Input"],

Cell[BoxData[
    \({{\(1 + \(h\ \[Lambda]\)\/2\)\/\(1 + \(5\ h\ \[Lambda]\)\/6 + \(h\^2\ \
\[Lambda]\^2\)\/6\), 
        0}, {\(-\(\(5\ h\ \[Lambda]\)\/\(6\ \((1 + \(5\ h\ \[Lambda]\)\/6 + \
\(h\^2\ \[Lambda]\^2\)\/6)\)\)\)\), \(1 + \(h\ \[Lambda]\)\/3\)\/\(1 + \(5\ h\
\ \[Lambda]\)\/6 + \(h\^2\ \[Lambda]\^2\)\/6\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(e = IdentityMatrix[2] + \((b - a)\)\)], "Input"],

Cell[BoxData[
    \({{1 - \(h\ \[Lambda]\)\/3, \(-\(\(4\ h\ \[Lambda]\)\/3\)\)}, {\(h\ \
\[Lambda]\)\/6, 1 - \(5\ h\ \[Lambda]\)\/6}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = d\  . \ e\)], "Input"],

Cell[BoxData[
    \({{\(\((1 - \(h\ \[Lambda]\)\/3)\)\ \((1 + \(h\ \[Lambda]\)\/2)\)\)\/\(1 \
+ \(5\ h\ \[Lambda]\)\/6 + \(h\^2\ \[Lambda]\^2\)\/6\), \(-\(\(4\ h\ \
\[Lambda]\ \((1 + \(h\ \[Lambda]\)\/2)\)\)\/\(3\ \((1 + \(5\ h\ \
\[Lambda]\)\/6 + \(h\^2\ \[Lambda]\^2\)\/6)\)\)\)\)}, {\(-\(\(5\ h\ \[Lambda]\
\ \((1 - \(h\ \[Lambda]\)\/3)\)\)\/\(6\ \((1 + \(5\ h\ \[Lambda]\)\/6 + \
\(h\^2\ \[Lambda]\^2\)\/6)\)\)\)\) + \(h\ \[Lambda]\ \((1 + \(h\ \
\[Lambda]\)\/3)\)\)\/\(6\ \((1 + \(5\ h\ \[Lambda]\)\/6 + \(h\^2\ \
\[Lambda]\^2\)\/6)\)\), \(10\ h\^2\ \[Lambda]\^2\)\/\(9\ \((1 + \(5\ h\ \
\[Lambda]\)\/6 + \(h\^2\ \[Lambda]\^2\)\/6)\)\) + \(\((1 - \(5\ h\ \
\[Lambda]\)\/6)\)\ \((1 + \(h\ \[Lambda]\)\/3)\)\)\/\(1 + \(5\ h\ \[Lambda]\)\
\/6 + \(h\^2\ \[Lambda]\^2\)\/6\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[f]\  \[Equal] \ 0, \ \[Lambda]]\)], "Input"],

Cell[BoxData[
    \({{\[Lambda] \[Rule] \(7 - \[ImaginaryI]\ \@23\)\/\(6\ h\)}, {\[Lambda] \
\[Rule] \(7 + \[ImaginaryI]\ \@23\)\/\(6\ h\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g = \[Nu]*c - e\)], "Input"],

Cell[BoxData[
    \({{\(-1\) + \(h\ \[Lambda]\)\/3 + \((1 + \(h\ \[Lambda]\)\/3)\)\ \[Nu], \
\(4\ h\ \[Lambda]\)\/3}, {\(-\(\(h\ \[Lambda]\)\/6\)\) + \(5\ h\ \[Lambda]\ \
\[Nu]\)\/6, \(-1\) + \(5\ h\ \[Lambda]\)\/6 + \((1 + \(h\ \[Lambda]\)\/2)\)\ \
\[Nu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[g]\)], "Input"],

Cell[BoxData[
    \(1 - \(7\ h\ \[Lambda]\)\/6 + \(h\^2\ \[Lambda]\^2\)\/2 - 
      2\ \[Nu] + \(h\ \[Lambda]\ \[Nu]\)\/3 - 
      2\/3\ h\^2\ \[Lambda]\^2\ \[Nu] + \[Nu]\^2 + 
      5\/6\ h\ \[Lambda]\ \[Nu]\^2 + 
      1\/6\ h\^2\ \[Lambda]\^2\ \[Nu]\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[g] \[Equal] 0, \ \[Nu]]\)], "Input"],

Cell[BoxData[
    \({{\[Nu] \[Rule] 
          1}, {\[Nu] \[Rule] \(6 - 7\ h\ \[Lambda] + 3\ h\^2\ \
\[Lambda]\^2\)\/\(6 + 5\ h\ \[Lambda] + h\^2\ \[Lambda]\^2\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = d\  . \ e\)], "Input"],

Cell[BoxData[
    \({{1\/2, \(-1\)}, {\(-\(1\/6\)\), 2\/3}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      put\ \[Alpha] = \[Lambda]\ h\ *) \)\(\[IndentingNewLine]\)\(Solve[
      6\  - \ 7\ \[Alpha] + \ 3\ \[Alpha]^2\  == \ 
        6 + \ 5\ \[Alpha] + \[Alpha]^2, \[Alpha]\ ]\)\)\)], "Input"],

Cell[BoxData[
    \({{\[Alpha] \[Rule] 0}, {\[Alpha] \[Rule] 6}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{51, Automatic}, {40, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 312, 6, 91, "Input"],
Cell[2054, 59, 333, 5, 61, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2424, 69, 68, 1, 27, "Input"],
Cell[2495, 72, 147, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2679, 79, 46, 1, 27, "Input"],
Cell[2728, 82, 790, 11, 177, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3555, 98, 74, 1, 27, "Input"],
Cell[3632, 101, 154, 2, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3823, 108, 48, 1, 27, "Input"],
Cell[3874, 111, 271, 4, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4182, 120, 39, 1, 27, "Input"],
Cell[4224, 123, 269, 5, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4530, 133, 66, 1, 27, "Input"],
Cell[4599, 136, 177, 3, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4813, 144, 46, 1, 27, "Input"],
Cell[4862, 147, 73, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4972, 153, 223, 4, 43, "Input"],
Cell[5198, 159, 78, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

